unit IWDBStdCtrls;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data,
  IWNetClasses, IWNetComponent, IWDBNavConfirmationConverter,
  IWDBNavImagesConverter,
  {$ENDIF}
  {$IFDEF Linux}QControls,
  {$ELSE}
    {$IFNDEF VSNET}
    Controls,
    {$ENDIF}
  {$ENDIF}
  Classes,
  {$IFNDEF VER130}
  Variants,
  {$ENDIF}
  DB,
  {$IFDEF CLR}
    IWNetFileParser,
  {$ELSE}
    IWFileParser,
  {$ENDIF}
  IWControl, IWCompCheckbox, IWCompEdit, IWCompLabel, IWCompListbox, IWCompMemo,
  IWCompText, IWHTMLTag, IWFileReference, IWGlobal,
  IWRenderContext, IWBaseInterfaces, IWBaseControl;

type
  TNavigateBtn = (
    {$IFDEF VSNET}nbNone = 0,{$ENDIF}
    nbFirst, nbPrior, nbNext, nbLast,
    nbInsert, nbDelete, nbEdit, nbPost, nbCancel, nbRefresh);
  {$IFDEF VSNET}
  [EditorAttribute('Atozed.Intraweb.Design.SetEditor, Atozed.Intraweb.Design', typeof(UITypeEditor))]
  {$ENDIF}
  TButtonSet = set of TNavigateBtn;

{$IFNDEF VSNET}
  TIWDBNavigator = class;
{$ENDIF}

  {$IFDEF VSNET}
  [TypeConverter(typeof(TIWDBNavImagesConverter))]
  {$ENDIF}
  TIWDBNavImages = class(TPersistent)
  protected
    FDelete: TIWFileReference;
    FPost: TIWFileReference;
    FCancel: TIWFileReference;
    FFirst: TIWFileReference;
    FNext: TIWFileReference;
    FInsert: TIWFileReference;
    FEdit: TIWFileReference;
    FRefresh: TIWFileReference;
    FLast: TIWFileReference;
    FPrior: TIWFileReference;
    //
    FDelete_Disabled: TIWFileReference;
    FPost_Disabled: TIWFileReference;
    FCancel_Disabled: TIWFileReference;
    FFirst_Disabled: TIWFileReference;
    FNext_Disabled: TIWFileReference;
    FInsert_Disabled: TIWFileReference;
    FEdit_Disabled: TIWFileReference;
    FRefresh_Disabled: TIWFileReference;
    FLast_Disabled: TIWFileReference;
    FPrior_Disabled: TIWFileReference;
    //
{$IFNDEF VSNET}    
    FParentDBNavigator: TIWDBNavigator;
{$ENDIF}
    procedure SetCancel(const Value: TIWFileReference);
    procedure SetDelete(const Value: TIWFileReference);
    procedure SetEdit(const Value: TIWFileReference);
    procedure SetFirst(const Value: TIWFileReference);
    procedure SetInsert(const Value: TIWFileReference);
    procedure SetLast(const Value: TIWFileReference);
    procedure SetNext(const Value: TIWFileReference);
    procedure SetPost(const Value: TIWFileReference);
    procedure SetPrior(const Value: TIWFileReference);
    procedure SetRefresh(const Value: TIWFileReference);
    procedure SetCancel_Disabled(const Value: TIWFileReference);
    procedure SetDelete_Disabled(const Value: TIWFileReference);
    procedure SetEdit_Disabled(const Value: TIWFileReference);
    procedure SetFirst_Disabled(const Value: TIWFileReference);
    procedure SetInsert_Disabled(const Value: TIWFileReference);
    procedure SetLast_Disabled(const Value: TIWFileReference);
    procedure SetNext_Disabled(const Value: TIWFileReference);
    procedure SetPost_Disabled(const Value: TIWFileReference);
    procedure SetPrior_Disabled(const Value: TIWFileReference);
    procedure SetRefresh_Disabled(const Value: TIWFileReference);
  public

    constructor Create({$IFNDEF VSNET}const AParenDBNav: TIWDBNavigator{$ENDIF}); overload;
    constructor Create(ACancel, ADelete, AEdit, AFirst, AInsert, ALast,
      ANext, APost, APrior, ARefresh, ACancelDisabled, ADeleteDisabled,
      AEditDisabled, AFirstDisabled, AInsertDisabled, ALastDisabled,
      ANextDisabled, APostDisabled, APriorDisabled, ARefreshDisabled: TIWFileReference); overload;

    destructor Destroy; override;
  published
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property First_Enabled: TIWFileReference read FFirst write SetFirst;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property First_Disabled: TIWFileReference read FFirst_Disabled write SetFirst_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Prior_Enabled: TIWFileReference read FPrior write SetPrior;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Prior_Disabled: TIWFileReference read FPrior_Disabled write SetPrior_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Next_Enabled: TIWFileReference read FNext write SetNext;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Next_Disabled: TIWFileReference read FNext_Disabled write SetNext_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Last_Enabled: TIWFileReference read FLast write SetLast;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Last_Disabled: TIWFileReference read FLast_Disabled write SetLast_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Edit_Enabled: TIWFileReference read FEdit write SetEdit;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Edit_Disabled: TIWFileReference read FEdit_Disabled write SetEdit_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Insert_Enabled: TIWFileReference read FInsert write SetInsert;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Insert_Disabled: TIWFileReference read FInsert_Disabled write SetInsert_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Delete_Enabled: TIWFileReference read FDelete write SetDelete;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Delete_Disabled: TIWFileReference read FDelete_Disabled write SetDelete_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Post_Enabled: TIWFileReference read FPost write SetPost;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Post_Disabled: TIWFileReference read FPost_Disabled write SetPost_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Cancel_Enabled: TIWFileReference read FCancel write SetCancel;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Cancel_Disabled: TIWFileReference read FCancel_Disabled write SetCancel_Disabled;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Refresh_Enabled: TIWFileReference read FRefresh write SetRefresh;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Refresh_Disabled: TIWFileReference read FRefresh_Disabled write SetRefresh_Disabled;
  end;

  {$IFDEF VSNET}
  [TypeConverter(typeof(TIWDBNavConfirmationConverter))]
  {$ENDIF}
  TIWDBNavConfirmations = class(TPersistent)
  protected
    FFirst: string;
    FPrior: string;
    FNext: string;
    FLast: string;
    FEdit: string;
    FInsert: string;
    FDelete: string;
    FPost: string;
    FCancel: string;
    FRefresh: string;
  public
    constructor Create(const ADesignMode: Boolean); overload;
    constructor Create(AFirst, APrior, ANext, ALast, AEdit, AInsert,
      ADelete, APost, ACancel, ARefresh: string); overload;

  published
    property First: string read FFirst write FFirst;
    property Prior: string read FPrior write FPrior;
    property Next: string read FNext write FNext;
    property Last: string read FLast write FLast;
    property Edit: string read FEdit write FEdit;
    property Insert: string read FInsert write FInsert;
    property Delete: string read FDelete write FDelete;
    property Post: string read FPost write FPost;
    property Cancel: string read FCancel write FCancel;
    property Refresh: string read FRefresh write FRefresh;
  end;


  TIWOrientation = (orHorizontal, orVertical);

{$IFNDEF VSNET}

  TIWDataLink = class(TDataLink)
  private
    FControl: TIWBaseControl;
  protected
    procedure ActiveChanged; override;
    procedure EditingChanged; override;
    procedure LayoutChanged; override;
    {$IFDEF CLR}
    procedure DataEvent(Event: TDataEvent; Info: TObject); override;
    {$ELSE}
    procedure DataEvent(Event: TDataEvent; Info: Longint); override;
    {$ENDIF}
    property Control: TIWBaseControl read FControl;
  public
    constructor Create(AControl: TIWBaseControl);
    destructor Destroy; override;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBCheckBox.bmp}
  TIWDBCheckBox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBCheckBox), 'TIWDBCheckBox.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBCheckBox = class(TIWCustomCheckBox)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FValueChecked: string;
    FValueUnchecked: string;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetDataField(const AValue: string);
    procedure SetValue(const AValue: string); override;

    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}

    procedure InitControl; override;
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write SetDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    property ValueChecked: string read FValueChecked write FValueChecked;
    property ValueUnchecked: string read FValueUnchecked write FValueUnchecked;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBComboBox.bmp}
  TIWDBComboBox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBComboBox), 'TIWDBComboBox.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBComboBox = class(TIWCustomCombobox)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;

    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}

    procedure InitControl; override;
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    property ItemIndex;
    property Items;
    property Sorted;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBEdit.bmp}
  TIWDBEdit = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBEdit), 'TIWDBEdit.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBEdit = class(TIWCustomEdit)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    procedure SetValue(const AValue: string); override;

    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    property FriendlyName;
    property PasswordPrompt;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBFile.bmp}
  TIWDBFile = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBFile), 'TIWDBFile.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBFile = class(TIWFile)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}

    procedure SetFileValue(AFile: THTTPFile); override;
    procedure InitControl; override;

    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLabel.bmp}
  TIWDBLabel = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLabel), 'TIWDBLabel.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBLabel = class(TIWCustomLabel)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoSize;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBListbox.bmp}
  TIWDBListbox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBListbox), 'TIWDBListbox.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBListbox = class(TIWCustomListbox)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FTrimValues: Boolean;
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property TrimValues: Boolean read FTrimValues write FTrimValues;
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    property Items;
    property ItemIndex;
    property Sorted;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupComboBox.bmp}
  TIWDBLookupComboBox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupComboBox), 'TIWDBLookupComboBox.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBLookupComboBox = class(TIWCustomCombobox)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
    function GetKeyValue: Variant;
    procedure SetKeyValue(const Value: Variant);
    procedure SetDisableWhenEmpty(const Value: boolean);
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FDisableWhenEmpty: boolean;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    FKeyValue: variant;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    property KeyValue: Variant read GetKeyValue write SetKeyValue;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}

    property DisableWhenEmpty: boolean read FDisableWhenEmpty write SetDisableWhenEmpty;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupListBox.bmp}
  TIWDBLookupListBox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupListBox), 'TIWDBLookupListBox.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBLookupListBox = class(TIWCustomListbox)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBMemo.bmp}
  TIWDBMemo = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBMemo), 'TIWDBMemo.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBMemo = class(TIWCustomMemo)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function SupportsInput: Boolean; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
  end;

  TIWDBNavigator = class(TIWCustomControl, IIWSubmitControl)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FSubmitParam : String;
    FConfirmations: TIWDBNavConfirmations;
    FDataSource: TDataSource;
    FImageWidth: Integer;
    FImageHeight: Integer;
    FOnFirst: TNotifyEvent;
    FOnPrior: TNotifyEvent;
    FOnNext: TNotifyEvent;
    FOnLast: TNotifyEvent;
    FOnEdit: TNotifyEvent;
    FOnInsert: TNotifyEvent;
    FOnDelete: TNotifyEvent;
    FOnPost: TNotifyEvent;
    FOnCancel: TNotifyEvent;
    FOnRefresh: TNotifyEvent;
    FVisibleButtons: TButtonSet;
    FDBNavImages: TIWDBNavImages;
    FOrientation: TIWOrientation;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetVisibleButtons(Value: TButtonSet);
    procedure SetDBNavImages(const Value: TIWDBNavImages);
    procedure SetOrientation(const Value: TIWOrientation);

    procedure InitControl; override;

    procedure Submit(const AValue: string); override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function GetSubmitParam : String;
  published
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Confirmations: TIWDBNavConfirmations read FConfirmations write FConfirmations;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    property ImageHeight: Integer read FImageHeight write FImageHeight;
    property ImageWidth: Integer read FImageWidth write FImageWidth;
    property VisibleButtons: TButtonSet read FVisibleButtons write SetVisibleButtons;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property CustomImages: TIWDBNavImages read FDBNavImages write SetDBNavImages;
    property Orientation: TIWOrientation read FOrientation write SetOrientation;
    //
    property OnFirst: TNotifyEvent read FOnFirst write FOnFirst;
    property OnPrior: TNotifyEvent read FOnPrior write FOnPrior;
    property OnNext: TNotifyEvent read FOnNext write FOnNext;
    property OnLast: TNotifyEvent read FOnLast write FOnLast;
    property OnEdit: TNotifyEvent read FOnEdit write FOnEdit;
    property OnInsert: TNotifyEvent read FOnInsert write FOnInsert;
    property OnDelete: TNotifyEvent read FOnDelete write FOnDelete;
    property OnPost: TNotifyEvent read FOnPost write FOnPost;
    property OnCancel: TNotifyEvent read FOnCancel write FOnCancel;
    property OnRefresh: TNotifyEvent read FOnRefresh write FOnRefresh;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBText.bmp}
  TIWDBText = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBText), 'TIWDBText.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBText = class(TIWCustomText)
  private
    FDataLink: TIWDataLink;
    {$IFNDEF VSNET}
    procedure SetDataSource(const Value: TDataSource);
    {$ENDIF}
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;

    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property ConvertSpaces;
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write SetDataSource;
    {$ENDIF}
    property FriendlyName;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property RawText;
    property UseFrame;
    property WantReturns;
  end;

{$ENDIF} // VSNET

implementation

// TODO: (for 5.1 or 6): to check all Combo and list box controls so they use ItemsHasValues

{$IFNDEF OBFUSCATE}
{$IFDEF VSNET}
  {$R IWDB.resx}
{$ELSE}
  {$R IWDB.res}
{$ENDIF}
{$ENDIF}

uses
  {$IFDEF Linux}
  Types,
  QButtons,
  QGraphics,
  {$ELSE}
  Windows,
  {$IFNDEF VSNET}
  Buttons,
  {$ENDIF}
  Graphics,
  {$ENDIF}
  IWResourceStrings, {$IFNDEF VSNET}IWDBCommon,{$ENDIF} IWServer, IWTypes,
  SWSystem, SysUtils;



{ TIWDBNavConfirmations }

constructor TIWDBNavConfirmations.Create(const ADesignMode: Boolean);
begin
  inherited Create;
  // Since Delphi does not write out empty strings, only default at design time so that
  // the user can set them to empty strings to disable them.
  // This does have a side effect of not defaulting if the user dynamically creates a DBNav.
  if ADesignMode then begin
    Delete := RSDeleteMessage;
    Post := RSUpdateMessage;
    Cancel := RSCancelMessage;
  end;
end;

constructor TIWDBNavConfirmations.Create(AFirst, APrior, ANext, ALast, AEdit, AInsert,
      ADelete, APost, ACancel, ARefresh: string);
begin
  inherited Create;
  FFirst := AFirst;
  FPrior := APrior;
  FNext := ANext;
  FLast := ALast;
  FEdit := AEdit;
  FInsert := AInsert;
  FDelete := ADelete;
  FPost := APost;
  FCancel := ACancel;
  FRefresh := ARefresh;
end;

{ TIWDBNavImages }

constructor TIWDBNavImages.Create({$IFNDEF VSNET}const AParenDBNav: TIWDBNavigator{$ENDIF});
begin
  inherited Create;
{$IFNDEF VSNET}
  FParentDBNavigator := AParenDBNav;
{$ENDIF}
  FDelete := TIWFileReference.Create;
  FPost := TIWFileReference.Create;
  FCancel := TIWFileReference.Create;
  FFirst := TIWFileReference.Create;
  FNext := TIWFileReference.Create;
  FInsert := TIWFileReference.Create;
  FEdit := TIWFileReference.Create;
  FRefresh := TIWFileReference.Create;
  FLast := TIWFileReference.Create;
  FPrior := TIWFileReference.Create;

  FDelete_Disabled := TIWFileReference.Create;
  FPost_Disabled := TIWFileReference.Create;
  FCancel_Disabled := TIWFileReference.Create;
  FFirst_Disabled := TIWFileReference.Create;
  FNext_Disabled := TIWFileReference.Create;
  FInsert_Disabled := TIWFileReference.Create;
  FEdit_Disabled := TIWFileReference.Create;
  FRefresh_Disabled := TIWFileReference.Create;
  FLast_Disabled := TIWFileReference.Create;
  FPrior_Disabled := TIWFileReference.Create;
end;

constructor TIWDBNavImages.Create(ACancel, ADelete, AEdit, AFirst, AInsert, ALast,
      ANext, APost, APrior, ARefresh, ACancelDisabled, ADeleteDisabled,
      AEditDisabled, AFirstDisabled, AInsertDisabled, ALastDisabled,
      ANextDisabled, APostDisabled, APriorDisabled, ARefreshDisabled: TIWFileReference);
begin
  inherited Create;
  FDelete.Assign(ADelete);
  FPost.Assign(APost);
  FCancel.Assign(ACancel);
  FFirst.Assign(AFirst);
  FNext.Assign(ANext);
  FInsert.Assign(AInsert);
  FEdit.Assign(AEdit);
  FRefresh.Assign(ARefresh);
  FLast.Assign(ALast);
  FPrior.Assign(APrior);

  FDelete_Disabled.Assign(ADeleteDisabled);
  FPost_Disabled.Assign(APostDisabled);
  FCancel_Disabled.Assign(ACancelDisabled);
  FFirst_Disabled.Assign(AFirstDisabled);
  FNext_Disabled.Assign(ANextDisabled);
  FInsert_Disabled.Assign(AInsertDisabled);
  FEdit_Disabled.Assign(AEditDisabled);
  FRefresh_Disabled.Assign(ARefreshDisabled);
  FLast_Disabled.Assign(ALastDisabled);
  FPrior_Disabled.Assign(APriorDisabled);
end;

destructor TIWDBNavImages.Destroy;
begin
  FreeAndNil(FDelete);
  FreeAndNil(FPost);
  FreeAndNil(FCancel);
  FreeAndNil(FFirst);
  FreeAndNil(FNext);
  FreeAndNil(FInsert);
  FreeAndNil(FEdit);
  FreeAndNil(FRefresh);
  FreeAndNil(FLast);
  FreeAndNil(FPrior);

  FreeAndNil(FDelete_Disabled);
  FreeAndNil(FPost_Disabled);
  FreeAndNil(FCancel_Disabled);
  FreeAndNil(FFirst_Disabled);
  FreeAndNil(FNext_Disabled);
  FreeAndNil(FInsert_Disabled);
  FreeAndNil(FEdit_Disabled);
  FreeAndNil(FRefresh_Disabled);
  FreeAndNil(FLast_Disabled);
  FreeAndNil(FPrior_Disabled);
  inherited Destroy;
end;

procedure TIWDBNavImages.SetCancel(const Value: TIWFileReference);
begin
  FCancel.Assign(Value);
end;

procedure TIWDBNavImages.SetCancel_Disabled(const Value: TIWFileReference);
begin
  FCancel_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetDelete(const Value: TIWFileReference);
begin
  FDelete.Assign(Value);
end;

procedure TIWDBNavImages.SetDelete_Disabled(const Value: TIWFileReference);
begin
  FDelete_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetEdit(const Value: TIWFileReference);
begin
  FEdit.Assign(Value);
end;

procedure TIWDBNavImages.SetEdit_Disabled(const Value: TIWFileReference);
begin
  FEdit_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetFirst(const Value: TIWFileReference);
begin
  FFirst.Assign(Value);
end;

procedure TIWDBNavImages.SetFirst_Disabled(const Value: TIWFileReference);
begin
  FFirst_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetInsert(const Value: TIWFileReference);
begin
  FInsert.Assign(Value);
end;

procedure TIWDBNavImages.SetInsert_Disabled(const Value: TIWFileReference);
begin
  FInsert_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetLast(const Value: TIWFileReference);
begin
  FLast.Assign(Value);
end;

procedure TIWDBNavImages.SetLast_Disabled(const Value: TIWFileReference);
begin
  FLast_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetNext(const Value: TIWFileReference);
begin
  FNext.Assign(Value);
end;

procedure TIWDBNavImages.SetNext_Disabled(const Value: TIWFileReference);
begin
  FNext_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetPost(const Value: TIWFileReference);
begin
  FPost.Assign(Value);
end;

procedure TIWDBNavImages.SetPost_Disabled(const Value: TIWFileReference);
begin
  FPost_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetPrior(const Value: TIWFileReference);
begin
  FPrior.Assign(Value);
end;

procedure TIWDBNavImages.SetPrior_Disabled(const Value: TIWFileReference);
begin
  FPrior_Disabled.Assign(Value);
end;

procedure TIWDBNavImages.SetRefresh(const Value: TIWFileReference);
begin
  FRefresh.Assign(Value);
end;

procedure TIWDBNavImages.SetRefresh_Disabled(
  const Value: TIWFileReference);
begin
  FRefresh_Disabled.Assign(Value);
end;



{$IFNDEF VSNET}

{ TIWDBEdit }

{$IFDEF VSNET}
procedure TIWDBEdit.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBEdit.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

procedure TIWDBEdit.Paint;
begin
  Text := DataField;
  inherited Paint;
end;

function TIWDBEdit.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
    if Editable then begin
      if LField.DataType in [ftDate, ftTime, ftDateTime] then begin
        Text := LField.DisplayText;
      end else begin
        Text := GetFieldText(LField);
      end;
    end else begin
      Text := LField.DisplayText;
    end;

    if (LField.DataType = ftString) then begin
      MaxLength := LField.Size;
    end;
  end else begin
    Text := '';
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBEdit.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if (GetFieldText(LField) <> Text) then begin
      FDatasource.Edit;
      LField.Text := Text;
    end;
  end;
end;

procedure TIWDBEdit.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFNDEF VSNET}
procedure TIWDBEdit.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

destructor TIWDBEdit.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

{$IFDEF VSNET}
procedure TIWDBEdit.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDatasource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBEdit.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBEdit.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

{ TIWDBLabel }

{$IFDEF VSNET}
procedure TIWDBLabel.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLabel.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLabel.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDatasource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBLabel.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLabel.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBLabel.Paint;
begin
  if DataField = '' then begin
    Caption := Name;
  end else begin
    Caption := DataField;
  end;
  inherited Paint;
end;

function TIWDBLabel.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    Caption := LField.DisplayText;
  end else begin
    Caption := '';
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBLabel.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFNDEF VSNET}
procedure TIWDBLabel.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

destructor TIWDBLabel.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

{ TIWDBMemo }

destructor TIWDBMemo.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

function TIWDBMemo.SupportsInput: Boolean;
begin
  // always return true because the control needs to be
  // initialy put in the form tag during umPartila
  result := True;
end;

procedure TIWDBMemo.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBMemo.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBMemo.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBMemo.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBMemo.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBMemo.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBMemo.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FLines.Text := GetFieldText(LField);
    FEndsWithCRLF := FLines.Text = GetFieldText(LField);
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FLines.Clear;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBMemo.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBMemo.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    // After SetValue Text holds the real value
    // When AValue does not end with CR-LF FLisnes automatically adds CRLF
    if (GetFieldText(LField) <> Text) then begin
      FDatasource.Edit;
      LField.AsString := Text;
    end;
  end;
end;

{ TIWDBNavigator }

destructor TIWDBNavigator.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FConfirmations);
  FreeAndNil(FDBNavImages);
  FreeAndNil(FDataLink);
  inherited Destroy;
end;

procedure TIWDBNavigator.InitControl;
var
  LUseDefaults: Boolean;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);

  LUseDefaults := False;
  {$IFNDEF VSNET}
  if Owner <> nil then begin
    LUseDefaults :=  (Owner.ComponentState * [csReading, csDesigning]) = [csDesigning];
  end;
  {$ENDIF}
  FConfirmations := TIWDBNavConfirmations.Create(LUseDefaults);
  FDBNavImages := TIWDBNavImages.Create(Self);
  //
  VisibleButtons := [nbFirst, nbPrior, nbNext, nbLast, nbInsert, nbDelete, nbEdit, nbPost, nbCancel
   , nbRefresh];
  Height := 28;
  Width := 250;
  ImageHeight := 24;
  ImageWidth := 24;
end;

{$IFDEF VSNET}
procedure TIWDBNavigator.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBNavigator.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBNavigator.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBNavigator.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBNavigator.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBNavigator.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWDBNavigator.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LBOF: Boolean;
  LCanModify: Boolean;
  LEOF: Boolean;
  LEditMode: Boolean;
  LValidDataset: Boolean;
  DBNavButtonNames: array [TNavigateBtn] of String;
const
  // Image offset in button - defined in IWDSNPainthandlers as well
  LCXOffset = 3;
  LCYOffset = 3;

  // Don't remove. Will need this for one more thing.
  DBNavButtonImages: array [TNavigateBtn] of String =
    ({$IFDEF VSNET}'',{$ENDIF}'First', 'Prior', 'Next', 'Last', 'Insert', 'Delete', 'Edit', { do not localize }
    'Post', 'Cancel', 'Refresh');                                  { do not localize }

  function DBNavImage(const AName: string; const AButton: TNavigateBtn; const AConfirmation: string;
    const AEnabled: Boolean = True; const ADoValidation: Boolean = True): TIWHTMLTag;
  Var
    LTag: TIWHTMLTag;
    LImageSrc: String;
    LFReference: TIWFileReference;
    LHint: String;
    LOldDoValidation: boolean;
    LOldConfirmation: string;
  begin
    //No EOL, it causes Whitespace in Netscape
    //TODO: Use PageImage

    // To avoid warining messages
    LFReference := nil;
    //
    if AEnabled then begin
      case AButton of
        nbFirst: LFReference := FDBNavImages.First_Enabled;
        nbPrior: LFReference := FDBNavImages.Prior_Enabled;
        nbNext: LFReference := FDBNavImages.Next_Enabled;
        nbLast: LFReference := FDBNavImages.Last_Enabled;
        nbInsert: LFReference := FDBNavImages.Insert_Enabled;
        nbDelete: LFReference := FDBNavImages.Delete_Enabled;
        nbEdit: LFReference := FDBNavImages.Edit_Enabled;
        nbPost: LFReference := FDBNavImages.Post_Enabled;
        nbCancel: LFReference := FDBNavImages.Cancel_Enabled;
        nbRefresh: LFReference := FDBNavImages.Refresh_Enabled;
      end;
    end
    else begin
      case AButton of
        nbFirst: LFReference := FDBNavImages.First_Disabled;
        nbPrior: LFReference := FDBNavImages.Prior_Disabled;
        nbNext: LFReference := FDBNavImages.Next_Disabled;
        nbLast: LFReference := FDBNavImages.Last_Disabled;
        nbInsert: LFReference := FDBNavImages.Insert_Disabled;
        nbDelete: LFReference := FDBNavImages.Delete_Disabled;
        nbEdit: LFReference := FDBNavImages.Edit_Disabled;
        nbPost: LFReference := FDBNavImages.Post_Disabled;
        nbCancel: LFReference := FDBNavImages.Cancel_Disabled;
        nbRefresh: LFReference := FDBNavImages.Refresh_Disabled;
      end;
    end;

    LImageSrc := LFReference.Location(GServerController.FilesURL);

    if LImageSrc = '' then begin
      LImageSrc := AContext.PageContext.WebApplication.InternalURLBase + '/gfx/DBNav_' + DBNavButtonImages[AButton] + iif(not (AEnabled and LValidDataset), 'Disabled') + '.gif';
    end;
    LTag := TIWHTMLTag.CreateTag('IMG');
    with LTag do try
      AddStringParam('SRC', LImageSrc);
      AddStringParam('ALT', DBNavButtonNames[AButton]);
      AddIntegerParam('BORDER', 0);
      AddStringParam('style', Format('position:relative;width:%d;height:%d;left:%dpx;top:0px;',
        [FImageWidth, FImageHeight, iif(AContext.PageContext.Browser = brNetscape7, -2, 0)]));
    except FreeAndNil(LTag); raise; end;

    if not IsDesignMode then begin
      if AEnabled then begin
        Result := TIWHTMLTag.CreateTag('BUTTON'); try
          Result.AddStringParam('style', Format('width:%d;height:%d;padding-left:0px;padding-top:0px;',
            [FImageWidth + LCXOffset * 2, FImageHeight + LCYOffset * 2]));
          LOldDoValidation := DoSubmitValidation;
          LOldConfirmation := Confirmation;
          DoSubmitValidation := ADoValidation;
          Confirmation := AConfirmation;
          Result.AddStringParam('OnClick', SubmitHandler(DBNavButtonNames[AButton], AName));
          DoSubmitValidation := LOldDoValidation;
          Confirmation := LOldConfirmation;
          Result.Contents.AddTagAsObject(LTag);
        except FreeAndNil(Result); raise; end;
      end else begin
        Result := TIWHTMLTag.CreateTag('BUTTON'); try
          Result.AddStringParam('style', Format('width:%d;height:%d;padding-left:0px;padding-top:0px;',
            [FImageWidth + LCXOffset * 2, FImageHeight + LCYOffset * 2]));
          Result.Contents.AddTagAsObject(LTag);
        except FreeAndNil(Result); raise; end;
      end;
    end;
    LHint := Hint;
    try
      Hint := DBNavButtonNames[AButton];
      HintEvents(Result);
    finally
      Hint := LHint;
    end;
  end;

Var
  LineTag: TIWHTMLTag;
  LTable: TIWHTMLTag;

  procedure AddImageTag(ATag: TIWHTMLTag);
  begin
    if LineTag = nil then begin
      LineTag := LTable.Contents.AddTag('TR');
    end
    else
      if Orientation = orVertical then begin
        LineTag := LTable.Contents.AddTag('TR');
      end;

    with LineTag.Contents.AddTag('TD') do begin
      AddIntegerParam('width', ImageWidth + 2 * LCXOffset);
      AddIntegerParam('height', ImageHeight + 2 * LCYOffset);
      Contents.AddTagAsObject(ATag);
    end;
  end;

begin
  DBNavButtonNames[nbFirst] := RSbtnNameFirst;
  DBNavButtonNames[nbPrior] := RSbtnNamePrior;
  DBNavButtonNames[nbNext] := RSbtnNameNext;
  DBNavButtonNames[nbLast] := RSbtnNameLast;
  DBNavButtonNames[nbInsert] := RSbtnNameInsert;
  DBNavButtonNames[nbDelete] := RSbtnNameDelete;
  DBNavButtonNames[nbEdit] := RSbtnNameEdit;
  DBNavButtonNames[nbPost] := RSbtnNamePost;
  DBNavButtonNames[nbCancel] := RSbtnNameCancel;
  DBNavButtonNames[nbRefresh] := RSbtnNameRefresh;

  Result := TIWHTMLTag.CreateTag('SPAN'); try
    LTable := Result.Contents.AddTag('TABLE');
    LValidDataset := CheckDatasource(FDataSource);
    LBOF := False;
    LEOF := False;
    LCanModify := False;
    LEditMode := False;
    if LValidDataset then begin
      LBOF := FDataSource.Dataset.BOF;
      LEOF := FDataSource.Dataset.EOF;
      LCanModify := FDataSource.Dataset.CanModify;
      LEditMode := InEditMode(FDataSource.Dataset);
    end;
    LTable.AddIntegerParam('cellspacing', 0);
    LTable.AddIntegerParam('border', 0);
    LTable.AddIntegerParam('cellpadding', 0);

    LineTag := nil;

    if nbFirst in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbFirst, Confirmations.First
        , (LBOF = False) and LValidDataset));
    end;
    if nbPrior in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbPrior, Confirmations.Prior
        , (LBOF = False) and LValidDataset));
    end;
    if nbNext in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbNext, Confirmations.Next
        , (LEOF = False) and LValidDataset));
    end;
    if nbLast in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbLast, Confirmations.Last
        , (LEOF = False) and LValidDataset));
    end;
    if nbEdit in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbEdit, Confirmations.Edit
        , (LEditMode = False) and LCanModify and LValidDataset));
    end;
    if nbInsert in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbInsert, Confirmations.Insert
        , (LEditMode = False) and LCanModify and LValidDataset));
    end;
    if nbDelete in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbDelete, Confirmations.Delete
        , (LEditMode = False) and LCanModify and LValidDataset and not FDataSource.Dataset.IsEmpty, False));
    end;
    if nbPost in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbPost, Confirmations.Post
        , LEditMode and LCanModify and LValidDataset));
    end;
    if nbCancel in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbCancel, Confirmations.Cancel
        , LEditMode and LCanModify and LValidDataset, False));
    end;
    if nbRefresh in VisibleButtons then begin
      AddImageTag(DBNavImage(HTMLName, nbRefresh, Confirmations.Refresh
        , (LEditMode = False) and LCanModify and LValidDataset, False));
    end;
    if LTable.Contents.Count = 0 then begin
      FreeAndNil(Result);
    end;
  except FreeAndNil(Result); raise; end;
end;

{$IFNDEF VSNET}
procedure TIWDBNavigator.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBNavigator.SetDBNavImages(const Value: TIWDBNavImages);
begin
  FDBNavImages.Assign(Value);
end;

procedure TIWDBNavigator.SetOrientation(const Value: TIWOrientation);
begin
  FOrientation := Value;
  Invalidate;
end;

procedure TIWDBNavigator.SetVisibleButtons(Value: TButtonSet);
begin
  FVisibleButtons := Value;
  Visible := Visible and (FVisibleButtons <> []);
  // The above is to prevent AV with TemplateProcesorwhen
  // no buttons visible.
  Invalidate;
end;

procedure TIWDBNavigator.Submit(const AValue: string);

  procedure DoEvent(AEvent: TNotifyEvent);
  begin
    if Assigned(AEvent) then begin
      AEvent(Self);
    end;
  end;

begin
  FSubmitParam := AValue;
  if CheckDatasource(FDataSource) then begin
    if SameText(AValue, RSbtnNameFirst) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.First;
      DoEvent(OnFirst);
    end else if SameText(AValue, RSbtnNamePrior) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.Prior;
      DoEvent(OnPrior);
    end else if SameText(AValue, RSbtnNameNext) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.Next;
      DoEvent(OnNext);
    end else if SameText(AValue, RSbtnNameLast) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.Last;
      DoEvent(OnLast);
    end else if SameText(AValue, RSbtnNameEdit) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.Edit;
      DoEvent(OnEdit);
    end else if SameText(AValue, RSbtnNameInsert) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Post;
      FDatasource.Dataset.Insert;
      DoEvent(OnInsert);
    end else if SameText(AValue, RSbtnNameDelete) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Cancel;
      FDatasource.Dataset.Delete;
      DoEvent(OnDelete);
    end else if SameText(AValue, RSbtnNamePost) then begin
      FDatasource.Dataset.Post;
      DoEvent(OnPost);
    end else if SameText(AValue, RSbtnNameCancel) then begin
      FDatasource.Dataset.Cancel;
      DoEvent(OnCancel);
    end else if SameText(AValue, RSbtnNameRefresh) then begin
      if InEditMode(FDatasource.Dataset) then
        FDatasource.Dataset.Cancel;
      {$IFNDEF VSNET}
      FDatasource.Dataset.Refresh;
      {$ENDIF}
      DoEvent(OnRefresh);
    end else begin
      raise Exception.Create(Format(RSInvalidResponse, [AValue]));
    end;
  end;
  DoRefreshControl := True;
end;

{ TIWDBText }

destructor TIWDBText.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBText.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBText.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBText.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBText.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBText.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBText.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBText.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.DataType in [ftDate, ftTime, ftDateTime] then begin
      FLines.Text := LField.DisplayText;
    end else begin
      FLines.Text := GetFieldText(LField);
    end;
  end else begin
    FLines.Clear;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBText.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

{ TIWDBCheckBox }

destructor TIWDBCheckBox.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBCheckBox.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  ValueChecked := 'true';
  ValueUnchecked := 'false';
  FDataField := '';
end;

{$IFDEF VSNET}                                                         
procedure TIWDBCheckBox.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBCheckBox.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBCheckBox.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBCheckBox.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBCheckBox.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBCheckBox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    Checked := AnsiSameText(ValueChecked, GetFieldText(LField));
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FChecked := False;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBCheckBox.SetDataField(const AValue: string);
begin
  FDataField := AValue;
  Invalidate;
end;

{$IFNDEF VSNET}
procedure TIWDBCheckBox.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBCheckBox.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    s := iif(FChecked, ValueChecked, ValueUnChecked);
   {
    if not LField.IsNull then begin // WHY? What if it's Null?   Ivan
      if not AnsiSameText(GetFieldText(LField), s) then begin
        DataSource.Edit;
        LField.Text := s;
      end;
    end;
    }
    if LField.IsNull or not AnsiSameText(GetFieldText(LField), s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBComboBox }

destructor TIWDBComboBox.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBComboBox.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBComboBox.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBComboBox.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBComboBox.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDatasource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBComboBox.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBComboBox.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBComboBox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  i : integer;
  sFieldText : string;
begin
  if CheckDataSource(FDataSource, DataField, LField) then
  begin
     if ItemsHaveValues then
     begin
        FItemIndex := -1;
        sFieldText := GetFieldText(LField);
        for i := 0 to Items.Count-1 do
        begin
           if Items.Values[Items.Names[i]]= sFieldText then
           begin
              FItemIndex := i;
              Break;
           end;
        end;
     end
     else
        FItemIndex := Items.IndexOf(GetFieldText(LField));
        if AutoEditable then
        begin
           Editable := InEditMode(FDataSource.Dataset);
        end;
  end
  else
  begin
     FItemIndex := -1;
     if AutoEditable then
     begin
        Editable := FALSE;
     end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBComboBox.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := Value;
end;
{$ENDIF}

procedure TIWDBComboBox.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FDataSource.DataSet.State <> dsBrowse then begin
      if FItemIndex > -1 then begin
        with Items do begin
          if ItemsHaveValues then begin
            s := Values[Names[FItemIndex]];
          end
          else begin
            s := Items[FItemIndex];
          end;
        end;
      end else begin
        s := '';
      end;
      if (GetFieldText(LField) <> s) then begin
        FDataSource.Edit;
        LField.Text := s;
      end;
    end;
  end;
end;

{ TIWDBListbox }

destructor TIWDBListbox.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBListbox.InitControl;
begin
  inherited;
  FTrimValues := True;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBListbox.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBListbox.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBListbox.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBListbox.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBListbox.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBListbox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  i : integer;
  sFieldText : string;
begin
  if CheckDataSource(FDataSource, DataField, LField) then
  begin
     if ItemsHaveValues then
     begin
        FItemIndex := -1;
        sFieldText := IIF(TrimValues, Trim(GetFieldText(LField)), GetFieldText(LField));
        for i := 0 to Items.Count-1 do
        begin
           if Items.Values[Items.Names[i]]= sFieldText then
           begin
              FItemIndex := i;
              Break;
           end;
        end;
     end
     else begin
        FItemIndex := Items.IndexOf(IIF(TrimValues, Trim(GetFieldText(LField)), GetFieldText(LField)));
        if AutoEditable then
        begin
           Editable := InEditMode(FDataSource.Dataset);
        end;
     end;
  end
  else
  begin
     FItemIndex := -1;
     if AutoEditable then
     begin
        Editable := FALSE;
     end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBListbox.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBListbox.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if ItemsHaveValues then begin
          s := Values[Names[FItemIndex]];
        end
        else begin
          s := Items[FItemIndex];
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBLookupComboBox }

function TIWDBLookupComboBox.GetKeyValue: Variant;
var
  LField: TField;
begin
  if FItemIndex <> -1 then
  begin
    if FKeyItems.Count > FItemIndex then
    begin
      Result := FKeyItems[FItemIndex]
    end
    else
    begin
      Result := -1;
    end
  end
  else
  begin
    if CheckDataSource(FDataSource, DataField, LField) then
    begin
      Result := null
    end
    else
    begin
      Result := FKeyValue;
    end;
  end;
end;

procedure TIWDBLookupComboBox.SetKeyValue(const Value: Variant);
var
  LField: TField;
begin
  FItemIndex := FKeyItems.IndexOf(Value);
  if not CheckDataSource(FDataSource, DataField, LField) then begin
    FKeyValue := Value;
  end;
end;

destructor TIWDBLookupComboBox.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  FreeAndNil(FKeyItems);
  inherited Destroy;
end;

procedure TIWDBLookupComboBox.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FKeyItems := TStringList.Create;
  FItemIndex := -1;
  FDataField := '';
  FKeyField := '';
  FDisableWhenEmpty := true;
  FListField := '';
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBox.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupComboBox.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListSource.Equals(AComponent) then begin
    {$ELSE}
    if FListSource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBox.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBLookupComboBox.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLookupComboBox.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupComboBox.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupComboBox.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupComboBox.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBLookupComboBox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  LKeyField: TField;
  LBookmark: TBookmark;
begin
  FKeyItems.Clear;
  Items.Clear;
  if CheckDataSource(FListSource, ListField, LField) and CheckDataSource(FListSource, KeyField, LKeyField) then
  begin
    LBookmark := FListSource.DataSet.GetBookmark;
    try
      FListSource.DataSet.First;
      while not FListSource.Dataset.EOF do
      begin
        Items.Add(GetFieldText(LField));
        FKeyItems.Add(LKeyField.AsString);
        FListSource.DataSet.Next;
      end;
      FListSource.DataSet.GotoBookmark(LBookMark);
    finally
      FListSource.DataSet.FreeBookmark(LBookmark);
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    if (GetKeyValue <> null) then
    begin
      FItemIndex := FKeyItems.IndexOf(GetKeyValue);
    end;
    if AutoEditable then begin
      Editable := False;
    end;
  end;

  if Items.Count = 0 then
  begin
    if FDisableWhenEmpty then
    begin
      Enabled := False;
      Result := inherited RenderHTML(AContext);
    end
    else
    begin
      Result := inherited RenderHTML(AContext);
      with Result.Contents.AddTag('OPTION') do
      begin
        Add('SELECTED');
        AddIntegerParam('VALUE', -1);
        Contents.AddText(FNoSelectionText);
      end;
    end;
  end
  else
  begin
    Result := inherited RenderHTML(AContext);
  end;
end;

{$IFNDEF VSNET}
procedure TIWDBLookupComboBox.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBLookupComboBox.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  if (FDataSource = nil) or (FDataSource.State in [dsEdit, dsInsert]) or AutoEditable then begin // js.  This if statement fixes an exception when you have AutoEditable = false and the lookup is on a required field.
    inherited SetValue(AValue);
    if CheckDataSource(FDataSource, DataField, LField) then begin
      if ItemIndex = -1 then begin
        s := #0;
      end else begin
        s := FKeyItems[ItemIndex];
      end;
      if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
        FDataSource.Edit;
        if s = #0 then begin
          LField.Clear;
        end else begin
          LField.Text := s;
        end;
      end;
    end;
  end;
end;

procedure TIWDBLookupComboBox.SetDisableWhenEmpty(const Value: boolean);
begin
  if (FDisableWhenEmpty <> Value) then
  begin
    FDisableWhenEmpty := Value;
    Invalidate;
  end;
end;

{ TIWDBLookupListBox }
destructor TIWDBLookupListBox.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FKeyItems);
  inherited Destroy;
end;

procedure TIWDBLookupListBox.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FKeyItems := TStringList.Create;
  FDataField := '';
  FKeyField := '';
  FListField := '';
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBox.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupListBox.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListsource.Equals(AComponent) then begin
    {$ELSE}
    if FListsource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBox.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBLookupListBox.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;
                
function TIWDBLookupListBox.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupListBox.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupListBox.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupListBox.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBLookupListBox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  LKeyField: TField;
begin
  Items.Clear;
  FKeyItems.Clear;
  if CheckDataSource(FListSource, ListField, LField)
   and CheckDataSource(FListSource, KeyField, LKeyField) then begin
    FListSource.DataSet.First;
    while not FListSource.Dataset.EOF do begin
      Items.Add(GetFieldText(LField));
      FKeyItems.Add(GetFieldText(LKeyField));
      FListSource.DataSet.Next;
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    //FItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBLookupListBox.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBLookupListBox.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex = -1 then begin
      s := #0;
    end else begin
      s := FKeyItems[FItemIndex];
    end;
    if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      if s = #0 then begin
        LField.Clear;
      end else begin
        LField.Text := s;
      end;
    end;
  end;
end;

{ TIWDBFile }

destructor TIWDBFile.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FDataLink);
  inherited;
end;

procedure TIWDBFile.InitControl;
begin
  inherited;
  FDataLink := TIWDataLink.Create(Self);
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBFile.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBFile.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBFile.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
  FDataLink.DataSource := FDataSource;
end;

function TIWDBFile.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBFile.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBFile.RenderHTML(
  AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Enabled := CheckDataSource(FDataSource);
  result := inherited RenderHTML(AContext);
end;

{$IFNDEF VSNET}
procedure TIWDBFile.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := FDataSource;
end;
{$ENDIF}

procedure TIWDBFile.SetFileValue(AFile: THTTPFile);
var
  LField: TField;
  LStream: TStream;
begin
  inherited SetFileValue(AFile);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if GetSize > 0 then begin
      FDatasource.Edit;
      LStream := LField.DataSet.CreateBlobStream(LField.DataSet.FieldByName(DataField), bmWrite);
      try
        SaveToStream(LStream);
      finally
        FreeAndNil(LStream);
      end;
    end;
  end;
end;

{ TIWDataLink }

procedure TIWDataLink.ActiveChanged;
begin
  inherited;
  if Assigned(FControl) then begin
    FControl.Invalidate;
  end;
end;

constructor TIWDataLink.Create(AControl: TIWBaseControl);
begin
  inherited Create;
  FControl := AControl;
end;

{$IFDEF CLR}
procedure TIWDataLink.DataEvent(Event: TDataEvent; Info: TObject);
{$ELSE}
procedure TIWDataLink.DataEvent(Event: TDataEvent; Info: Longint); 
{$ENDIF}
begin
  inherited;
  case Event of
    deDataSetChange: begin
      if Assigned(FControl) then begin
        FControl.Invalidate;
      end;
    end;
  end;
end;

destructor TIWDataLink.Destroy;
begin
  inherited;
end;

procedure TIWDataLink.EditingChanged;
begin
  inherited;
  if Assigned(FControl) then begin
    FControl.Invalidate;
  end;
end;

procedure TIWDataLink.LayoutChanged;
begin
  inherited;
  if Assigned(FControl) then begin
    FControl.Invalidate;
  end;
end;

{$ENDIF}

initialization
  TIWServer.AddInternalFile('IW_GFX_DBNav_Cancel', '/gfx/DBNav_Cancel.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_delete', '/gfx/DBNav_Delete.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_edit', '/gfx/DBNav_Edit.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_first', '/gfx/DBNav_First.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_insert', '/gfx/DBNav_Insert.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_last', '/gfx/DBNav_Last.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_next', '/gfx/DBNav_Next.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_post', '/gfx/DBNav_Post.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_prior', '/gfx/DBNav_Prior.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_refresh', '/gfx/DBNav_Refresh.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_CancelDisabled', '/gfx/DBNav_CancelDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_deleteDisabled', '/gfx/DBNav_DeleteDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_editDisabled', '/gfx/DBNav_EditDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_firstDisabled', '/gfx/DBNav_FirstDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_insertDisabled', '/gfx/DBNav_InsertDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_lastDisabled', '/gfx/DBNav_LastDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_nextDisabled', '/gfx/DBNav_NextDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_postDisabled', '/gfx/DBNav_PostDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_priorDisabled', '/gfx/DBNav_PriorDisabled.gif');
  TIWServer.AddInternalFile('IW_GFX_DBNav_refreshDisabled', '/gfx/DBNav_RefreshDisabled.gif');
end.
